IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'dbo.CF_BancoBBVA_Proveedores_OP_Reg_20_TX') 
                   and type = 'FN')
BEGIN
    DROP FUNCTION dbo.CF_BancoBBVA_Proveedores_OP_Reg_20_TX
END
GO

CREATE FUNCTION [dbo].[CF_BancoBBVA_Proveedores_OP_Reg_20_TX](@pId_Trans INT, @pCuitEmpresa VARCHAR(13), @pNroSecuencia INT) 
RETURNS CHAR(850)
AS
BEGIN

/*================================================================================================================================*/

/*Variables del Archivo.*/
DECLARE @Retorno						CHAR(850)

/*--------------------------------------------------------------------------------------------------------------------------------*/

DECLARE @aIDENT_REGISTRO			CHAR(4)	--NRO: 01. NOMBRE: IDENT-REGISTRO.          TIPO: N. TAM: 004. POS. INI: 001. POS_FIN: 004. OBSERVACION:OBL fijo 0306
DECLARE @aTIPO_REG					CHAR(3)	--NRO: 02. NOMBRE: TIPO-REG.                TIPO: N. TAM: 003. POS. INI: 005. POS_FIN: 007. OBSERVACION:OBL fijo 020
DECLARE @aTIPO_DOC_EMPRE			CHAR(4)	--NRO: 03. NOMBRE: TIPO-DOC-EMPRE.          TIPO: X. TAM: 004. POS. INI: 008. POS_FIN: 011. OBSERVACION:OBL 'CUIT' tipo documento
DECLARE @aNRO_CUIT_EMPRE			CHAR(13)--NRO: 04. NOMBRE: NRO-CUIT-EMPRE.          TIPO: N. TAM: 013. POS. INI: 012. POS_FIN: 024. OBSERVACION:OBL numero de cuit
DECLARE @aSECUENCIA					CHAR(6)	--NRO: 05. NOMBRE: SECUENCIA.               TIPO: N. TAM: 006. POS. INI: 025. POS_FIN: 030. OBSERVACION:OBL Numero correlativo
DECLARE @aPRO_NRO_BENEFICIARIO		CHAR(15)--NRO: 06. NOMBRE: PRO-NRO-BENEFICIARIO.    TIPO: N. TAM: 015. POS. INI: 031. POS_FIN: 045. OBSERVACION:OBL Codigo de identificacion del beneficiario igual al numero informado en el registro 090 
DECLARE @aNRO_MINUTA				CHAR(8)	--NRO: 07. NOMBRE: NRO-MINUTA.              TIPO: N. TAM: 008. POS. INI: 046. POS_FIN: 053. OBSERVACION:OBL numero de orden de pago. Debe ser mayor a ceros.  Si el pago es con impresion de minutas no puede repetirse.
DECLARE @aIMPORTE					CHAR(13)--NRO: 08. NOMBRE: IMPORTE.                 TIPO: N. TAM: 013. POS. INI: 054. POS_FIN: 066. OBSERVACION:OBL Numerico  con dos decimales. Importe neto del pago.   
DECLARE @aNRO_CERT_RET_GANANCIAS	CHAR(14)--NRO: 09. NOMBRE: NRO-CERT-RET-GANANCIAS.  TIPO: X. TAM: 014. POS. INI: 067. POS_FIN: 080. OBSERVACION:OPC Libre llenado. Si se informa retencion de Ganancias este campo debe venir informado.
DECLARE @aREGIMEN_GANANCIAS			CHAR(30)--NRO: 10. NOMBRE: REGIMEN-GANANCIAS.       TIPO: X. TAM: 030. POS. INI: 081. POS_FIN: 110. OBSERVACION:OPC Libre llenado
DECLARE @aIMP_RET_GANANCIAS			CHAR(13)--NRO: 11. NOMBRE: IMP-RET-GANANCIAS.       TIPO: N. TAM: 013. POS. INI: 111. POS_FIN: 123. OBSERVACION:OPC Numerico con dos decimales. Solo si la empresa imprimira comprobante de retencion.  De informarse debe venir un registro tipo 040 con codigo de retencion IG o GA.  Si es libre impresion no se informa.
DECLARE @aNRO_CERT_RET_IVA			CHAR(14)--NRO: 12. NOMBRE: NRO-CERT-RET-IVA.        TIPO: X. TAM: 014. POS. INI: 124. POS_FIN: 137. OBSERVACION:OPC Libre llenado. Si informan retencion de IVA se debera informar.
DECLARE @aREGIMEN_IVA				CHAR(30)--NRO: 13. NOMBRE: REGIMEN-IVA.             TIPO: X. TAM: 030. POS. INI: 138. POS_FIN: 167. OBSERVACION:OPC Libre llenado
DECLARE @aPRO_NRO_ORD				CHAR(15)--NRO: 14. NOMBRE: PRO-NRO-ORD  .           TIPO: X. TAM: 015. POS. INI: 168. POS_FIN: 182. OBSERVACION:OBL Nombre del archivo
DECLARE @aFILLER_A					CHAR(8)	--NRO: 15. NOMBRE: FILLER.                  TIPO: X. TAM: 008. POS. INI: 183. POS_FIN: 190. OBSERVACION:OPC espacios
DECLARE @aACRED_A_SUSP				CHAR(1)	--NRO: 16. NOMBRE: ACRED-A-SUSP.            TIPO: X. TAM: 001. POS. INI: 191. POS_FIN: 191. OBSERVACION:OPC Relleno a blancos
DECLARE @aIPERMFIN					CHAR(1)	--NRO: 17. NOMBRE: IPERMFIN.                TIPO: X. TAM: 001. POS. INI: 192. POS_FIN: 192. OBSERVACION:OPC Para forma de pago CH indica  financiacion automatica. S: permite.  Blanco o N: no se utiliza
DECLARE @aCLI_AJE					CHAR(1)	--NRO: 18. NOMBRE: CLI-AJE.                 TIPO: X. TAM: 001. POS. INI: 193. POS_FIN: 193. OBSERVACION:OPC cliente ajeno. 'S' si es con acreditacion en cuenta de otro banco.  Debe tener CBU cargada en datos del proveedor tipo registro 090. Si es BF completar con blancos.
DECLARE @aNCUIT_PAGO				CHAR(13)--NRO: 19. NOMBRE: NCUIT-PAGO.              TIPO: N. TAM: 013. POS. INI: 194. POS_FIN: 206. OBSERVACION:OPC nro cuit de beneficiario de pago. Se completa si el destinatario del cheque es distinto al de la minuta.
DECLARE @aNOME_PAGO					CHAR(40)--NRO: 20. NOMBRE: NOME-PAGO.               TIPO: X. TAM: 040. POS. INI: 207. POS_FIN: 246. OBSERVACION:OPC nombre de beneficiario de pago. Se completa si el destinatario del cheque es distinto al de la minuta.
DECLARE @aTIPO_DOCUMENTO			CHAR(3)	--NRO: 21. NOMBRE: TIPO-DOCUMENTO.          TIPO: X. TAM: 003. POS. INI: 247. POS_FIN: 249. OBSERVACION:OBL Tipo de documento proveedor. Se corresponde con el del diseo de proveedores tipo registro 090.
DECLARE @aNRO_DOCUMENTO				CHAR(11)--NRO: 22. NOMBRE: NRO-DOCUMENTO.           TIPO: X. TAM: 011. POS. INI: 250. POS_FIN: 260. OBSERVACION:OBL Nro de documento proveedor. Se corresponde con el del diseo de proveedores tipo registro 090.
DECLARE @aSUC_ENTREGA				CHAR(4)	--NRO: 23. NOMBRE: SUC-ENTREGA.             TIPO: N. TAM: 004. POS. INI: 261. POS_FIN: 264. OBSERVACION:OBL sucursal en donde se entregara la documentacion
DECLARE @aFECHA_ENTREGA				CHAR(8)	--NRO: 24. NOMBRE: FECHA-ENTREGA.           TIPO: N. TAM: 008. POS. INI: 265. POS_FIN: 272. OBSERVACION:OPC Fecha de entrega. Debe ser igual o mayor a la fecha de emision formato aaaammdd. Si la modalidad de pago es acreditacion en cuenta o CPD debe ser habil. ACLARACIoN: integrar solo si no se completo en la cabecera.
DECLARE @aFECHA_PAGO				CHAR(8)	--NRO: 25. NOMBRE: FECHA-PAGO.              TIPO: N. TAM: 008. POS. INI: 273. POS_FIN: 280. OBSERVACION:OPC Fecha de pago. Si es CPD debe ser mayor a la fecha de entrega formato aaaammdd. Si es credito en cuenta debe ser habil y mayor o igual a la fecha de entrega. Si es cheque al dia  debe ser igual a la de entrega. ACLARACIoN: integrar solo si no se completo en la cabecera.
DECLARE @aFORMA_PAGO				CHAR(2)	--NRO: 26. NOMBRE: FORMA-PAGO.              TIPO: X. TAM: 002. POS. INI: 281. POS_FIN: 282. OBSERVACION:OPC Forma de pago. AB para Acreditacion en cuenta. CH para Emision de Cheques CPD y cheques al dia. MP si se informa mas de un instrumento de pago para una orden de pago (Reg-25). ACLARACIoN: integrar solo si no se completo en la cabecera, caso contrario informar blancos.
DECLARE @aFORMA_COBRO				CHAR(1)	--NRO: 27. NOMBRE: FORMA-COBRO.             TIPO: N. TAM: 001. POS. INI: 283. POS_FIN: 283. OBSERVACION:OPC completo con ceros. ACLARACIoN: integrar solo si no se completo en la cabecera.
DECLARE @aDISPON_P					CHAR(1)	--NRO: 28. NOMBRE: DISPON-P.                TIPO: N. TAM: 001. POS. INI: 284. POS_FIN: 284. OBSERVACION:OPC En caso de informar Forma de Pago CH, indicar 0 para CPD cruzado no a la orden; 1 CPD cruzado a la orden; 2 CPD no cruzado a la orden; 3 CPD no cruzado no a la orden; 4 Cheque al dia cruzado no a la orden; 5 Cheque al dia cruzado a la orden; 6 Cheque al dia no cruzado a la orden; 7 Cheque al dia no cruzado no a la orden. En caso de informar Forma de Pago AB, indicar 0 para Contrato (ve contrato); 1 para COELSA; 2 para CCI (si el CBU relacionado con el pago es de un banco que no forma parte de INTERBANKING, para no rechazar la transferencia, se cambia por 1 y la misma se hara por COELSA). En caso contrario debe ir completo con ceros. ACLARACIoN: integrar solo si no se completo en la cabecera.
DECLARE @aDEPOSITO					CHAR(1)	--NRO: 29. NOMBRE: DEPOSITO.                TIPO: N. TAM: 001. POS. INI: 285. POS_FIN: 285. OBSERVACION:OPC Completar con cero 
DECLARE @aNRO_CHEQUE				CHAR(13)--NRO: 30. NOMBRE: NRO-CHEQUE.              TIPO: N. TAM: 013. POS. INI: 286. POS_FIN: 298. OBSERVACION:OPC Numero de cheque emitido. Obligatorio si el parametro Informa Numero de Cheque del contrato tienen la marca en S. Informar comenzando con 8 alineado a la izquierda, y justificar con ceros a la derecha.
DECLARE @aCOD_DEVOLUCION			CHAR(6)	--NRO: 31. NOMBRE: COD-DEVOLUCION.          TIPO: X. TAM: 006. POS. INI: 299. POS_FIN: 304. OBSERVACION:OPC Relleno a blancos.  En la devolucion se envia el numero de codigo de devolucion.
DECLARE @aDESC_DEVOLUCION			CHAR(40)--NRO: 32. NOMBRE: DESC-DEVOLUCION.         TIPO: A. TAM: 040. POS. INI: 305. POS_FIN: 344. OBSERVACION:OPC. Descripciones relacionadas al Codigo de Devolucion.
DECLARE @aFILLER_B					CHAR(506)--NRO: 33. NOMBRE: FILLER.                 TIPO: X. TAM: 506. POS. INI: 345. POS_FIN: 850. OBSERVACION:Relleno a  blancos
/*FIN Variables del Archivo*/

/*================================================================================================================================*/

/*Variables de Calculo intermedio*/
DECLARE @Id_Proveedor				INT
DECLARE @Imp_Total					DECIMAL(12,2)
DECLARE @Cuit_Proveedor				VARCHAR(11)
DECLARE @Fecha_Cbte					DATETIME
DECLARE @Cant_Forma_Pagos			TINYINT
DECLARE @Id_Tipo_Val				CHAR(3)
DECLARE @Fecha_Emision				DATETIME
DECLARE @Fecha_Acreditacion			DATETIME
DECLARE @Transferible				TINYINT
/*FIN Variables de Calculo intermedio*/


/*Asignacion de variables*/
SELECT
@Id_Proveedor	= ISNULL(Id_Proveedor, 0),
@Fecha_Cbte		= ISNULL(Fecha, '19000101')
FROM Cbtes
WHERE
Id_Trans = @pId_Trans

SELECT
@Imp_Total		= ISNULL(Importe, 0)
FROM Valores
WHERE
Id_Trans = @pId_Trans

SELECT
@Cuit_Proveedor		= SUBSTRING(LTRIM(RTRIM(ISNULL(Cuit, ''))), 1, 11)
FROM Proveedores
WHERE
Id_Proveedor = @Id_Proveedor

SET @Cant_Forma_Pagos = ISNULL((SELECT COUNT(*) FROM Valores WHERE Id_Trans = @pId_Trans), 0)
IF(@Cant_Forma_Pagos = 1)
BEGIN
	SELECT
	@Id_Tipo_Val		= ISNULL(Id_Tipo_Val, '   '),
	@Fecha_Emision		= CONVERT(DATE, ISNULL(Fecha_Emision, '19000101')),
	@Fecha_Acreditacion	= CONVERT(DATE, ISNULL(Fecha_Acreditacion, '19000101')),
	@Transferible		= ISNULL(Transferible, 0)
	FROM Valores
	WHERE
	Id_Trans		= @pId_Trans	
END
/*FIN Asignacion de variables*/

/*================================================================================================================================*/

SET @aIDENT_REGISTRO			= '0306'
SET @aTIPO_REG					= '020'
SET @aTIPO_DOC_EMPRE			= 'CUIT'
SET @aNRO_CUIT_EMPRE			= (SELECT RIGHT('0000000000000' + CAST(@pCuitEmpresa AS VARCHAR), 13))
SET @aSECUENCIA					= (SELECT RIGHT('000000' + CAST(@pNroSecuencia AS VARCHAR), 6))
SET @aPRO_NRO_BENEFICIARIO		= (SELECT RIGHT('000000000000000' + CAST(@Id_Proveedor AS VARCHAR), 15))
SET @aNRO_MINUTA				= (SELECT RIGHT('00000000' + CAST(@pId_Trans AS VARCHAR), 8))
SET @aIMPORTE					= (SELECT RIGHT( '0000000000000' + CAST(CAST((ISNULL(@Imp_Total,0)) * 100 AS INT) AS VARCHAR), 13))
SET @aNRO_CERT_RET_GANANCIAS	= '              '
SET @aREGIMEN_GANANCIAS			= '                              '
SET @aIMP_RET_GANANCIAS			= '0000000000000'
SET @aNRO_CERT_RET_IVA			= '              '
SET @aREGIMEN_IVA				= '                              '
SET @aPRO_NRO_ORD				= 'PUBL_MP        ' --12/07/2022 antes estaba fijo: 'CASO01 MP  PAP ', se cambio porque la rta indicaba que debia ser el mismo valor de @aPRO_NRO_ORD de CF_BancoBBVA_Proveedores_OP_Reg_90_TX
SET @aFILLER_A					= '        '
SET @aACRED_A_SUSP				= ' '
SET @aIPERMFIN					= ' '
SET @aCLI_AJE					= 'S'	/*14/04/2020 Modificado por Ticket 19.334 (x comentario 13/04/20 15:15)*/
SET @aNCUIT_PAGO				= '0000000000000'
SET @aNOME_PAGO					= '                                        '
SET @aTIPO_DOCUMENTO			= 'CUI' /*CUIT*/
SET @aNRO_DOCUMENTO				= (SELECT RIGHT('00000000000' + CAST(@Cuit_Proveedor AS VARCHAR), 11))
SET @aSUC_ENTREGA				= '0152' --?????
SET @aFECHA_ENTREGA				= (/*AAAA*/CAST(DATEPART(YY, @Fecha_Cbte) AS CHAR(4)) + /*MM*/RIGHT('00' + CAST(DATEPART(mm, @Fecha_Cbte) AS VARCHAR),2) + /*DD*/RIGHT('00' + CAST(DATEPART(dd, @Fecha_Cbte) AS VARCHAR),2))
SET @aFECHA_PAGO				= @aFECHA_ENTREGA /*16/04/2020 Cambiado x Ticket 19.334. Comentario: 16/04/20 10:10 ANTES: '00000000'*/

IF(@Cant_Forma_Pagos > 1)
BEGIN
	SET @aFORMA_PAGO			= 'MP'
END
ELSE
BEGIN
	IF(@Id_Tipo_Val IN ('CH3', 'CHP'))
	BEGIN
		SET @aFORMA_PAGO		= 'CH'
	END
	ELSE
	BEGIN
		SET @aFORMA_PAGO		= 'AB' /*Acreditacion en Cuenta*/
	END	
END

SET @aFORMA_COBRO				= '0'

/*OPC  En caso de informar 
Forma de Pago 

CH, indicar 0 para CPD cruzado no a la orden; 
			1 CPD cruzado a la orden; 
			2 CPD no cruzado a la orden; 
			3 CPD no cruzado no a la orden; 
			4 Cheque al dia cruzado no a la orden; 
			5 Cheque al dia cruzado a la orden; 
			6 Cheque al dia no cruzado a la orden; 
			7 Cheque al dia no cruzado no a la orden. 
			
AB, indicar 0 para Contrato (ve contrato); 
			1 para COELSA; 
			2 para CCI (si el CBU relacionado con el pago es de un banco que no forma parte de INTERBANKING, para no rechazar la transferencia, se cambia por 1 y la misma se hara por COELSA).
En caso contrario debe ir completo con ceros.
ACLARACIoN: integrar solo si no se completo en la cabecera.*/
IF(@Cant_Forma_Pagos > 1)
BEGIN
	SET @aDISPON_P				= 9
END
ELSE
BEGIN
	IF(@Fecha_Emision = @Fecha_Acreditacion)
	BEGIN
		/*Cheque al dia*/
		IF(@Transferible = 1)
		BEGIN
			/*No a la orden*/
			SET @aDISPON_P		= 4
		END
		ELSE
		BEGIN
			/*A la Orden*/
			SET @aDISPON_P		= 5
		END
	END
	ELSE
	BEGIN
		/*Cheque Pago Diferido (CPD)*/
		IF(@Transferible = 1)
		BEGIN
			/*No a la orden*/
			SET @aDISPON_P		= 0
		END
		ELSE
		BEGIN
			/*A la Orden*/
			SET @aDISPON_P		= 1
		END
	END	
END

SET @aDISPON_P = 0 /*16/04/2020 Cambiado x Ticket 19.334. Comentario: 16/04/20 10:10 ANTES: Todo el IF de Arriba, aca lo pisa siempre 0*/

SET @aDEPOSITO					= '0'
SET @aNRO_CHEQUE				= '0000000000000'
SET @aCOD_DEVOLUCION			= '      '
SET @aDESC_DEVOLUCION			= '                                        '
SET @aFILLER_B					= '                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          '

/*================================================================================================================================*/

SET @Retorno =	@aIDENT_REGISTRO +
				@aTIPO_REG +
				@aTIPO_DOC_EMPRE +
				@aNRO_CUIT_EMPRE +
				@aSECUENCIA +
				@aPRO_NRO_BENEFICIARIO +
				@aNRO_MINUTA +
				@aIMPORTE +
				@aNRO_CERT_RET_GANANCIAS +
				@aREGIMEN_GANANCIAS +
				@aIMP_RET_GANANCIAS +
				@aNRO_CERT_RET_IVA +
				@aREGIMEN_IVA +
				@aPRO_NRO_ORD +
				@aFILLER_A +
				@aACRED_A_SUSP +
				@aIPERMFIN +
				@aCLI_AJE +
				@aNCUIT_PAGO +
				@aNOME_PAGO +
				@aTIPO_DOCUMENTO +
				@aNRO_DOCUMENTO +
				@aSUC_ENTREGA +
				@aFECHA_ENTREGA +
				@aFECHA_PAGO +
				@aFORMA_PAGO +
				@aFORMA_COBRO +
				@aDISPON_P +
				@aDEPOSITO +
				@aNRO_CHEQUE +
				@aCOD_DEVOLUCION +
				@aDESC_DEVOLUCION +
				@aFILLER_B

/*================================================================================================================================*/
					
RETURN @Retorno
END
